

<?php $__env->startSection('title', 'My Appointments'); ?>

<?php $__env->startSection('content'); ?>
<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
    <div class="mb-6 flex flex-col sm:flex-row justify-between items-start sm:items-center gap-4">
        <h1 class="text-3xl font-bold text-gray-800">My Appointments</h1>
        <a href="<?php echo e(route('doctor.dashboard')); ?>" class="bg-gray-600 hover:bg-gray-700 text-white px-4 py-2 rounded">
            <i class="fas fa-arrow-left mr-2"></i>Back to Dashboard
        </a>
    </div>

    <div class="bg-white rounded-lg shadow overflow-hidden">
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-3 sm:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Patient</th>
                        <th class="px-3 sm:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase hidden md:table-cell">Branch</th>
                        <th class="px-3 sm:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase hidden lg:table-cell">Pharmacist</th>
                        <th class="px-3 sm:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Date</th>
                        <th class="px-3 sm:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase hidden sm:table-cell">Type</th>
                        <th class="px-3 sm:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Status</th>
                        <th class="px-3 sm:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Actions</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    <?php $__currentLoopData = $appointments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $appointment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td class="px-3 sm:px-6 py-4 whitespace-nowrap">
                            <span class="text-sm sm:text-base"><?php echo e($appointment->patient->full_name); ?></span>
                        </td>
                        <td class="px-3 sm:px-6 py-4 whitespace-nowrap hidden md:table-cell">
                            <span class="text-sm"><?php echo e($appointment->branch->name); ?></span>
                        </td>
                        <td class="px-3 sm:px-6 py-4 whitespace-nowrap hidden lg:table-cell">
                            <span class="text-sm"><?php echo e($appointment->pharmacist->full_name); ?></span>
                        </td>
                        <td class="px-3 sm:px-6 py-4 whitespace-nowrap">
                            <span class="text-xs sm:text-sm"><?php echo e($appointment->appointment_date->format('M d, Y H:i')); ?></span>
                        </td>
                        <td class="px-3 sm:px-6 py-4 whitespace-nowrap hidden sm:table-cell">
                            <span class="text-xs sm:text-sm"><?php echo e($appointment->consultation_type); ?></span>
                        </td>
                        <td class="px-3 sm:px-6 py-4 whitespace-nowrap">
                            <span class="px-2 py-1 text-xs rounded-full bg-<?php echo e($appointment->status === 'completed' ? 'green' : ($appointment->status === 'pending' ? 'yellow' : 'blue')); ?>-100 text-<?php echo e($appointment->status === 'completed' ? 'green' : ($appointment->status === 'pending' ? 'yellow' : 'blue')); ?>-800">
                                <?php echo e(ucfirst($appointment->status)); ?>

                            </span>
                        </td>
                        <td class="px-3 sm:px-6 py-4 whitespace-nowrap text-xs sm:text-sm font-medium">
                            <div class="flex flex-col sm:flex-row gap-1 sm:gap-2">
                                <?php if($appointment->google_meet_link): ?>
                                    <a href="<?php echo e($appointment->google_meet_link); ?>" target="_blank" class="text-green-600 hover:text-green-900 whitespace-nowrap">
                                        <i class="fas fa-video"></i> <span class="hidden sm:inline">Google Meet</span><span class="sm:hidden">Meet</span>
                                    </a>
                                <?php elseif($appointment->video_call_room_id): ?>
                                    <a href="<?php echo e(route('doctor.video-call', $appointment->id)); ?>" class="text-blue-600 hover:text-blue-900 whitespace-nowrap">
                                        <i class="fas fa-video"></i> <span class="hidden sm:inline">Join Video Call</span><span class="sm:hidden">Video</span>
                                    </a>
                                <?php endif; ?>
                                <?php if($appointment->status !== 'completed'): ?>
                                    <a href="<?php echo e(route('prescriptions.create', $appointment->id)); ?>" class="text-green-600 hover:text-green-900 whitespace-nowrap">
                                        <span class="hidden sm:inline">Create Prescription</span><span class="sm:hidden">Create</span>
                                    </a>
                                <?php elseif($appointment->prescription): ?>
                                    <a href="<?php echo e(route('prescriptions.show', $appointment->prescription->id)); ?>" class="text-purple-600 hover:text-purple-900 whitespace-nowrap">
                                        <span class="hidden sm:inline">View Prescription</span><span class="sm:hidden">View</span>
                                    </a>
                                <?php endif; ?>
                            </div>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\BrainTech\Documents\BEAUTEZ SYSTEM\resources\views/doctor/appointments.blade.php ENDPATH**/ ?>